/* TOS 4.04 Videl debug output for the CT60/CTPCI boards
 * Didier Mequignon 2010, e-mail: aniplay@wanadoo.fr
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "../include/vars.h"

#ifdef DEBUG
 
	.global _debug_traps,_trace_tos,vdu
	
	.data
	
_trace_tos:

	movem.l D0/D1/A0/A1,-(SP)
	lea.l 16+6(SP),A0
	move.w (A0)+,D1          // format
	btst #5,16(SP)           // call in supervisor state
	bne.s .t2
	move.l USP,A0
.t2:
	and.w #0x3C,D1
	lea _debug_traps,A1
	move.l (A1,D1.w),ret
	lsr.w #3,D1
	and.w #3,D1
	cmp.w #1,D1
	beq.s .t3                // AES / VDI
	lea tabaff(PC),A1
	move.b (A1,D1.w),D0
	bsr vdu
	moveq #0x3A,D0           // :
	bsr vdu
	move.w (A0),D0           // function
	bra.s .t4
.t3:
	movem.l (SP),D0/D1/A0/A1
	cmp.w #0xC8,D0           // AES
	bne.s .t5
	moveq #0x41,D0           // A
	bra.s .t6
.t5:
	cmp.w #0x73,D0           // VDI
	bne.s .t1
	move.l D1,A0             // VDIPTR
	move.l (A0),A0           // CONTROL
	move.w (A0),D0
	cmp.w #0x1F,D0
	beq.s .t1
	cmp.w #0x21,D0
	beq.s .t1
	cmp.w #0x7C,D0
	beq.s .t1
	cmp.w #0x80,D0
	beq.s .t1
	moveq #0x56,D0           // V VDI
.t6:
	bsr vdu
	moveq #0x3A,D0           // :
	bsr vdu
	move.l D1,A0             // AESPTR ou VDIPTR
	move.l (A0),A0           // CONTROL
	move.w (A0),D0           // opcode function
.t4:
	bsr hex                  // opcode function
	moveq #13,D0
	bsr vdu
	moveq #10,D0
	bsr vdu
.t1:
	movem.l (SP)+,D0/D1/A0/A1
	move.l ret,-(SP)
	rts

physbase:

	move.l D0,-(SP)
	moveq #0,D0
	move.b 0xFFFF8201,D0     // video screen memory position, high byte 
	asl.l #8,D0
	move.b 0xFFFF8203,D0     // mid byte
	asl.l #8,D0
	move.b 0xFFFF820D,D0     // low byte
	move.l D0,A0
	move.l (SP)+,D0
	rts

clear_line:

#if 0	/* 4 characters */
	movem.l D0/A0,-(SP)
	bsr physbase             // target is ST-high only !
	move.w ypos,D0
	mulu #8*80,D0
	add.l D0,A0              // position Y
	clr.l (A0)
	clr.l 80(A0)
	clr.l 160(A0)
	clr.l 240(A0)
	clr.l 320(A0)
	clr.l 400(A0)
	clr.l 480(A0)
	clr.l 560(A0)
	movem.l (SP)+,D0/A0
             rts
#else
	movem.l D0-A3,-(SP)
	bsr physbase             // target is ST-high only !
	move.w ypos,D0
	mulu #8*80,D0
	add.l D0,A0              // position Y
	moveq #0,D1
	moveq #0,D2
	moveq #0,D3
	moveq #0,D4
	moveq #0,D5
	moveq #0,D6
	moveq #0,D7
	move.l D7,A1
	move.l D7,A2
	move.l D7,A3
	movem.l D1-D7/A1-A3,(A0)
	movem.l D1-D7/A1-A3,40(A0)
	movem.l D1-D7/A1-A3,80(A0)
	movem.l D1-D7/A1-A3,120(A0)
	movem.l D1-D7/A1-A3,160(A0)
	movem.l D1-D7/A1-A3,200(A0)
	movem.l D1-D7/A1-A3,240(A0)
	movem.l D1-D7/A1-A3,280(A0)
	movem.l D1-D7/A1-A3,320(A0)
	movem.l D1-D7/A1-A3,360(A0)
	movem.l D1-D7/A1-A3,400(A0)
	movem.l D1-D7/A1-A3,440(A0)
	movem.l D1-D7/A1-A3,480(A0)
	movem.l D1-D7/A1-A3,520(A0)
	movem.l D1-D7/A1-A3,560(A0)
	movem.l D1-D7/A1-A3,600(A0)
	movem.l (SP)+,D0-A3
             rts
#endif
             
hex:

	move.w D0,-(SP)
	lsr.w #4,D0
	bsr hexa
	move.w (SP)+,D0

hexa:

	and.w #0xF,D0
	or.w #0x30,D0
	cmp.w #0x3A,D0
	bcs.s vdu
	addq.w #7,D0

vdu:

	movem.l D0-D1/A0-A1,-(SP)
	and.w #0x7F,D0
	bsr physbase             // target is ST-high only !
	add.w xpos,A0            // position X/8 => screen base
	move.w ypos,D1
	mulu #8*80,D1
	add.l D1,A0              // position Y
	cmp.w #10,D0             // LF
	bne.s .v3
	addq.w #1,ypos
	cmp.w #400/8,ypos
	bcs.s .v2
	clr.w ypos
.v2:
	bsr clear_line
	bra.s .v1
.v3:
	cmp.w #13,D0             // CR
	bne.s .v4
	clr.w xpos
	bra.s .v1
.v4:	
	sub.w #0x20,D0
	bmi.s .v1
	mulu #8,D0
	lea cara(PC),A1          // character table address base
	add.l D0,A1
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	lea 80(A0),A0
	move.b (A1)+,(A0)
	addq.w #1,xpos
	cmp.w #80,xpos
	bcs.s .v1
	clr.w xpos
	addq.w #1,ypos
	cmp.w #400/8,ypos
	bcs.s .v5
	clr.w ypos
.v5:
	bsr clear_line
.v1:
	movem.l (SP)+,D0-D1/A0-A1
	rts

tabaff:	.ascii "GABX"

cara:	// matrix 8*8
	.byte 0,0,0,0,0,0,0,0 
	.byte 0x18,0x18,0x18,0x18,0x18,0,0x18,0 // !
	.byte 0x66,0x66,0x66,0,0,0,0,0 // "
	.byte 0,0x6C,0xFE,0x6C,0x6C,0xFE,0x6C,0 // #
	.byte 0x18,0x3E,0x60,0x3C,0x6,0x7C,0x18,0 // $
	.byte 0,0x66,0x6C,0x18,0x30,0x66,0x46,0 // %
	.byte 0x38,0x6C,0x38,0x70,0xDE,0xCC,0x76,0 // &
	.byte 0x18,0x18,0x18,0,0,0,0,0 // '
	.byte 0xE,0x1C,0x18,0x18,0x18,0x1C,0xE,0 // (
	.byte 0x70,0x38,0x18,0x18,0x18,0x38,0x70,0 // )
	.byte 0,0x66,0x3C,0xFF,0x3C,0x66,0,0 // *
	.byte 0,0x18,0x18,0x7E,0x18,0x18,0,0 // +
	.byte 0,0,0,0,0,0x30,0x30,0x60 // ,
	.byte 0,0,0,0x7E,0,0,0,0 // -
	.byte 0,0,0,0,0,0x18,0x18,0 // .
	.byte 0x2,0x6,0xC,0x18,0x30,0x60,0x40,0 // /
	.byte 0x3C,0x66,0x6E,0x76,0x66,0x66,0x3C,0 // 0
	.byte 0x18,0x38,0x18,0x18,0x18,0x18,0x7E,0 // 1
	.byte 0x3C,0x66,0x6,0xC,0x18,0x30,0x7E,0 // 2
	.byte 0x7E,0xC,0x18,0xC,0x6,0x66,0x3C,0 // 3
	.byte 0xC,0x1C,0x3C,0x6C,0x7E,0xC,0xC,0 // 4
	.byte 0x7E,0x60,0x7C,0x6,0x6,0x66,0x3C,0 // 5
	.byte 0x3C,0x60,0x60,0x7C,0x66,0x66,0x3C,0 // 6
	.byte 0x7E,0x6,0xC,0x18,0x30,0x30,0x30,0 // 7
	.byte 0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0 // 8
	.byte 0x3C,0x66,0x66,0x3E,0x6,0xC,0x38,0 // 9
	.byte 0,0x18,0x18,0,0x18,0x18,0,0 // :
	.byte 0,0x18,0x18,0,0x18,0x18,0x30,0
	.byte 0x6,0xC,0x18,0x30,0x18,0xC,0x6,0 // <
	.byte 0,0,0x7E,0,0,0x7E,0,0 // =
	.byte 0x60,0x30,0x18,0xC,0x18,0x30,0x60,0 // >
	.byte 0x3C,0x66,0x6,0xC,0x18,0,0x18,0 // ?
	.byte 0x3C,0x66,0x6E,0x6A,0x6E,0x60,0x3E,0 // @
	.byte 0x18,0x3C,0x66,0x66,0x7E,0x66,0x66,0 // A
	.byte 0x7C,0x66,0x66,0x7C,0x66,0x66,0x7C,0 // B
	.byte 0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0 // C
	.byte 0x78,0x6C,0x66,0x66,0x66,0x6C,0x78,0 // D
	.byte 0x7E,0x60,0x60,0x7C,0x60,0x60,0x7E,0 // E
	.byte 0x7E,0x60,0x60,0x7C,0x60,0x60,0x60,0 // F
	.byte 0x3E,0x60,0x60,0x6E,0x66,0x66,0x3E,0 // G
	.byte 0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0 // H
	.byte 0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0 // I
	.byte 0x6,0x6,0x6,0x6,0x6,0x66,0x3C,0 // J
	.byte 0x66,0x6C,0x78,0x70,0x78,0x6C,0x66,0 // K
	.byte 0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0 // L
	.byte 0xC6,0xEE,0xFE,0xD6,0xC6,0xC6,0xC6,0 // M
	.byte 0x66,0x76,0x7E,0x7E,0x6E,0x66,0x66,0 // N
	.byte 0x3C,0x66,0x66,0x66,0x66,0x66,0x3C,0 // O
	.byte 0x7C,0x66,0x66,0x7C,0x60,0x60,0x60,0 // P
	.byte 0x3C,0x66,0x66,0x66,0x76,0x6C,0x36,0 // Q
	.byte 0x7C,0x66,0x66,0x7C,0x6C,0x66,0x66,0 // R
	.byte 0x3C,0x66,0x60,0x3C,0x6,0x66,0x3C,0 // S
	.byte 0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0 // T
	.byte 0x66,0x66,0x66,0x66,0x66,0x66,0x3E,0 // U
	.byte 0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0 // V
	.byte 0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0 // W
	.byte 0x66,0x66,0x3C,0x18,0x3C,0x66,0x66,0 // X
	.byte 0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0 // Y
	.byte 0x7E,0x6,0xC,0x18,0x30,0x60,0x7E,0 // Z
	.byte 0x1E,0x18,0x18,0x18,0x18,0x18,0x1E,0 // [
	.byte 0x40,0x60,0x30,0x18,0xC,0x6,0x2,0
	.byte 0x78,0x18,0x18,0x18,0x18,0x18,0x78,0 // ]
	.byte 0x10,0x38,0x6C,0xC6,0,0,0,0 // ^
	.byte 0,0,0,0,0,0,0xFE,0 // _
	.byte 0,0xC0,0x60,0x30,0,0,0,0 // `
	.byte 0,0,0x3C,0x6,0x3E,0x66,0x3E,0 // a
	.byte 0x60,0x60,0x7C,0x66,0x66,0x66,0x7C,0 // b
	.byte 0,0,0x3C,0x60,0x60,0x60,0x3C,0 // c
	.byte 0x6,0x6,0x3E,0x66,0x66,0x66,0x3E,0 // d
	.byte 0,0,0x3C,0x66,0x7E,0x60,0x3C,0 // e
	.byte 0x1C,0x30,0x7C,0x30,0x30,0x30,0x30,0 // f
	.byte 0,0,0x3E,0x66,0x66,0x3E,0x6,0x7C // g
	.byte 0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0 // h
	.byte 0x18,0,0x38,0x18,0x18,0x18,0x3C,0 // i
	.byte 0x18,0,0x18,0x18,0x18,0x18,0x18,0x70 // j
	.byte 0x60,0x60,0x66,0x6C,0x78,0x6C,0x66,0 // k
	.byte 0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0 // l
	.byte 0,0,0xEC,0xFE,0xD6,0xC6,0xC6,0 // m
	.byte 0,0,0x7C,0x66,0x66,0x66,0x66,0 // n
	.byte 0,0,0x3C,0x66,0x66,0x66,0x3C,0 // o
	.byte 0,0,0x7C,0x66,0x66,0x66,0x7C,0x60 // p
	.byte 0,0,0x3E,0x66,0x66,0x66,0x3E,0x6 // q
	.byte 0,0,0x7C,0x66,0x60,0x60,0x60,0 // r
	.byte 0,0,0x3E,0x60,0x3C,0x6,0x7C,0 // s
	.byte 0,0x18,0x7E,0x18,0x18,0x18,0xE,0 // t
	.byte 0,0,0x66,0x66,0x66,0x66,0x3E,0 // u
	.byte 0,0,0x66,0x66,0x66,0x3C,0x18,0 // v
	.byte 0,0,0xC6,0xC6,0xD6,0x7C,0x6C,0 // w
	.byte 0,0,0x66,0x3C,0x18,0x3C,0x66,0 // x
	.byte 0,0,0x66,0x66,0x66,0x3E,0x6,0x7C // y
	.byte 0,0,0x7E,0xC,0x18,0x30,0x7E,0 // z
	.byte 0xE,0x18,0x18,0x30,0x18,0x18,0xE,0 // {
	.byte 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // |
	.byte 0x70,0x18,0x18,0xC,0x18,0x18,0x70,0 // }
	.byte 0,0x60,0xF2,0x9E,0xC,0,0,0 // ~
	.byte 0,0,0,0,0,0,0,0

	.align 2

	.lcomm xpos,2
	.lcomm ypos,2
	.lcomm ret,4
	
#endif /* DEBUG */

